import pandas as pd   
from sklearn.model_selection import train_test_split  
import pickle
from sklearn.linear_model import LogisticRegression

# Load the dataset   
credit_customers = pd.read_csv("credit_customers.csv") 
  
X = credit_customers.drop('class', axis=1)   
y = credit_customers['class']   

# Split data into training and testing sets   
X_train, X_test, y_train, y_test = train_test_split(X, y, test_size=0.3, random_state=42)  

log_reg = LogisticRegression(max_iter=1000)   
log_reg.fit(X_train, y_train)    

pickle.dump(X_train,open("./ref_result/X_train.pkl","wb"))
pickle.dump(X_test,open("./ref_result/X_test.pkl","wb"))
pickle.dump(y_train,open("./ref_result/y_train.pkl","wb"))
pickle.dump(y_test,open("./ref_result/y_test.pkl","wb"))
pickle.dump(log_reg,open("./ref_result/log_reg.pkl","wb"))